#pragma once

// ciana. Jedyny element sceny w przykadzie, z ktrym wykrywane bd kolizje.
// Jest to dowolny quad ktrego wszystkie wierzchoki le na jednej paszczynie (wane!).
// ciana bdzie rysowana oraz zostanie utworzony i zapamitany czworokt na potrzeby
// wykrywania kolizji.
class CWall : public CSceneObject
{
public:
	CWall(vec3 a, vec3 b, vec3 c, vec3 d); // Konstruktor - pozycje czterech wierzchokw (musz lee na jednej paszczynie!). Ich kolejno decyduje o zwrocie wektora normalnego. Podajemy je przeciwnie do ruchu wskazwek zegara.
	~CWall(void); // Destruktor.
	void Initialize(void); // Inicjalizacja (wywoana raz).
	void Update(void); // Aktualizacja stanu.
	void Render(void); // Rysowanie ciany.
	CCollisionPolygon * collisionPolygon; // Polygon (a tak naprawd po prostu czworokt), z ktrym bd wykrywane kolizje.
	vec3 v[4]; // Pozycje wierzchokw.
	vec3 n; // Wektor normalny ciany.

protected:
	GLuint _displayListId; // Id displaylisty.
	static bool _isLoaded; // Czy tekstura zostaa ju zaadowana (jest identyczna dla wszystkich instancji klasy)?
	static CTexture * _wallTexture; // Tekstura.
};

