#pragma once

// Element sceny - klasa abstrakcyjna, ktra w zaoeniu powinna by
// klas bazow dla wszystkich elementw sceny.
// Dziki temu, e wszystkie obiekty bd dziedziczyy po tej klasie,
// moliwe jest choby wygodne trzymanie ujednoliconej ich listy.
class CSceneObject
{
public:
	vec3 Position; // Pozycja obiektu na scenie.
	vec3 Rotation; // Rotacja (trzy kty) obiektu na scenie.
	char *Name; // Nazwa obiektu uatwiajca ich rozpoznawanie (gwnie programicie).

	CSceneObject(void); // Konstruktor.
	~CSceneObject(void); // Destruktor.
	virtual void Initialize(void) = 0; // Inicjalizacja obiektu - wywoana raz na pocztku.
	virtual void Update(void) = 0; // Aktualizacja stanu obiektu - wywoywana cyklicznie, np. jako timer.
	virtual void Render(void) = 0; // Rysowanie obiektu - wywoywane zawsze podczas rysowania tego elementu sceny.
};

