#pragma once

// Scena - Jest to podstawowy element organizujcy hierarchi obiektw w grze.
// Z zaoenia, w danym momencie powinna istnie tylko jedna scena.
// W sytuacji gdy scen moe by wicej, dobrze jest utworzy klasy dziedziczce po tej.
class CScene
{
public:
	
	CSkydome * Skydome; // Skydome - niebo.
	CTerrain * Terrain; // Teren - czyli w naszym przykadzie trawiasty quad.
	CPlayer Player; // Stan gracza.

	// Wszystkie obiekty na scenie, wektor na podstawie ktrego bdzie mona
	// po nich atwo iterowa, np. w celu ich narysowania.
	vector<CSceneObject *> * Objects;

	CScene(void); // Konstruktor.
	~CScene(void); // Destruktor.
	void Initialize(void); // Inicjalizacja (wywoywana raz).
	void Update(void); // Aktualizacja wiata.
	void Render(void); // Rysowanie caej sceny.
	
	bool DrawCollisions; // Czy maj by rysowane kolizje (do debugowania, klawisz "K")?
	bool DrawNormals; // Czy maj by rysowane wektory normalne (do debugowania, klawisz "N")?
	vec3 LastCollisionPoint; // Pozycja ostatniej kolizji.
	bool MarkCollision; // Czy ju zaistniaa jakakolwiek kolizja warta narysowania?

};

