#pragma once

class CSceneObject;

// Wielokt sucy do wykrywania kolizji oraz metody do tego przydatne.
class CCollisionPolygon {
public:

	vec3 * v; // Tablica wierzchokw polygonu.
	int vNum; // Liczba wierzchokw.

	CSceneObject * parent; // Element sceny, do ktrego przynaley polygon.

	// Konstruktor - utworzenie polygonu na podstawie tablicy wierzchokw.
	// Wszystkie wierzchoki musz lee na jednej paszczynie!
	CCollisionPolygon(vec3 nV[], int nVNum) {
		parent = NULL;
		vNum = nVNum;
		v = new vec3[vNum];
		for (int i = 0; i < vNum; ++i) {
			v[i] = nV[i];
		}
	}
	
	// Destruktor - sprztanie wiata.
	~CCollisionPolygon() {
		delete[] v;
	}

	// Sprawdzenie, czy na odcinku pos0 => pos1 dochodzi do kolizji elipsoidy e z naszym polygonem.
	void CheckCollision(vec3 pos0, vec3 pos1, CCollisionEllipsoid * e, SCollision &result);

	// Sprawdzenie, czy punkt p ley wewntrz naszego polygonu.
	bool CheckPointInPolygon(vec3 p, vec3 *vv);

};
