#include "stdafx.h"

void CCollisionPolygon::CheckCollision(vec3 pos0, vec3 pos1, CCollisionEllipsoid * e, SCollision &result) {
	// Sprawdzenie, czy na odcinku pos0 => pos1 dochodzi do kolizji elipsoidy e z naszym polygonem.

	// Pierwszy krok to transformacja do przestrzeni "elipsoidalnej". Przechodzimy do takiej przestrzeni,
	// w ktrej nasza elipsoida jest kul o r=1.0. Dziki temu znacznie uprocimy obliczenia.
	// Aby tego dokona, skalujemy kad wsprzdn wiata przez odwrotno dugoci odpowiadajcego promienia elipsoidy.
	// Na koniec bdziemy musieli powrci do pierwotnej przestrzeni, poprzez przemnoenie wsprzdnych
	// przez NIEodwrcone dugoci promieni.

	// Transformujemy pooenia wierzchokw polygonu, "vv" bdzie zawiera pozycje w nowej przestrzeni.
	vec3 * vv = new vec3[vNum];
	for (int i = 0; i < vNum; ++i) {
		vv[i] = v[i];
		vv[i].Scale(e->rInv);
	}
	// Trzeba pamita, eby przed wyjciem z funkcji zwolni pami po vv!

	// Utworzenie paszczyzny przechodzcej przez punkty "vv".
	CCollisionPlane plane(vv);

	// Transformacja pocztku i koca naszego ruchu (pos0 i pos1).
	vec3 basePoint = pos0;
	vec3 destinationPoint = pos1;
	basePoint.Scale(e->rInv);
	destinationPoint.Scale(e->rInv);
	
	// Obliczenie wektora przemieszczenia w nowej przestrzeni, oraz znormalizowanego wektora kierunku.
	vec3 vel = destinationPoint - basePoint;
	vec3 velNormalized = vel;
	velNormalized.Normalize();

	// Pniej w razie wystpienia kolizji zapiszemy pod t zmienn wektor kierunku,
	// w jakim powinna nastpi reakcja na kolizj (odbicie si).
	vec3 reaction;

	#pragma region Sprawdzenie kolizji z paszczyzn na ktrej ley polygon.

		// Nie interesuj nas kolizje zachodzce podczas poruszania si "zza" paszczyzny.
		// Inaczej moe doj do nieprzyjemnego blokowania si.
		if (!plane.IsFrontFacingTo(velNormalized)) {
			delete[] vv;
			return;
		}

		float t0, t1; // Punkty pierwszego i drugiego przecicia powierzchni kuli z paszczyzn (wejcie i wyjcie).
		bool embeddedInPlane = false;

		// Odlego rodka kuli (dawnej elipsy) od najbliszego punktu paszczyny.
		float distance = plane.SDistanceTo(basePoint);

		float normalDotVel = plane.N.Dot(vel);

		// Jeli poruszamy si rwnolegle do paszczyzny...
		if (normalDotVel == 0.0f) {
			if (abs(distance) >= 1.0f) {
				// rodek kuli jest dalej od paszczyzny, ni jej dugo promienia => nie ma kolizji.
				delete[] vv;
				return;
			}
			// W innym wypadku wnioskujemy, e paszczyzna przecina kul na caej dugoci ruchu.
			embeddedInPlane = true;
			t0 = 0.0f;
			t1 = 1.0f;
		}

		// Jeli NIE poruszamy si rwnolegle do paszczyzny...
		else {
			// Punkty przecicia dwch punktw na powierzchni kuli z paszczyzn.
			t0 = (-1.0f - distance) / normalDotVel;
			t1 = ( 1.0f - distance) / normalDotVel;

			// Uporzdkowanie, aby t0 byo zawsze mniejsz z wartoci.
			if (t0 > t1) {
				float tmp = t1;
				t1 = t0;
				t0 = tmp;
			}

			// Sprawdzenie, czy zachodzi kolizja z paszczyzn na rozpatrywanym odcinku.
			if (t0 > 1.0f || t1 < 0.0f) {
				// t0 i t1 s poza zakresem 0..1 => nie ma kolizji.
				delete[] vv;
				return;
			}

			// Clamping do przedziau 0..1.
			t0 = __max(0.0f, __min(1.0f, t0));
			t1 = __max(0.0f, __min(1.0f, t1));
		}

	#pragma endregion

	// Wiemy ju, e gdzie dochodzi do przecicia/zetknicia kuli z paszczyzn.
	// Pozostaje "tylko" sprawdzi, czy to miejsce znajduje si wewntrz, na wierzchoku
	// lub krawdzi polygonu, czy te jest zupenie gdzie indziej i wtedy nie zachodzi kolizja.

	vec3 collisionPoint;
	float tc = 1.0f;
	bool collided = false;

	#pragma region Sprawdzenie kolizji z wntrzem polygonu.
	
		if (!embeddedInPlane) {
			
			// Obliczamy punkt na paszczynie z bliszym (wczeniejszym) miejscem przecicia kuli.
			vec3 planeIntersectionPoint = (basePoint - plane.N) + vel * t0;

			// Czy punkt znajduje si wewntrz polygonu?
			if (CheckPointInPolygon(planeIntersectionPoint, vv)) {
				// Mamy kolizj!
				tc = t0;
				collided = true;
				collisionPoint = planeIntersectionPoint; // Punktem kolizji bdzie punkt na paszczynie.
				reaction = plane.N; // Kierunkiem reakcji/odbicia bdzie wektor normalny paszczyzny.
				
				//printf("%s: interior\n", parent->Name);
			}

		}
	
	#pragma endregion
		
	if (!collided) {

		float t = 1.0f; // Nasz najlepszy do tej pory wynik - jeli znajdziemy kolizj z wierzchokiem lub krawdzi, to t si zmniejszy.
		vec3 velocity = vel;
		vec3 base = basePoint;
		float velocityL2 = vel.Length2(); // Czsto bdziemy uywa kwadratu dugoci prdkoci, wic wyliczamy go raz.
		float a, b, c; // Wspczynniki rwnania kwadratowego.
		float newT; // Miejsce, gdzie bdzie wpisywana warto nowowyliczonego "t".

		#pragma region Sprawdzenie kolizji z wierzchokami polygonu.

			// Wymaga rozwizania rwnania kwadratowego dla kadego z wierzchokw polygonu.
			// Wytumaczenie wspczynnikw a, b, c znale mona w sugerowanej literaturze.

			a = velocityL2; // "a" jest wsplne dla wszystkich wierzchokw.

			// Dla kadego wierzchoka rozwiemy rwnanie z innymi "b" i "c".
			for (int i = 0; i < vNum; ++i) {
				b = 2.0f * (velocity.Dot(base - vv[i]));
				c = (vv[i] - base).Length2() - 1.0f;
				if (CCollisionDetection::GetSmallestPositiveQuadEqSolution(a, b, c, t, newT)) {
					// Udao si znale lepsze od poprzedniego rozwizanie. Mamy kolizj!
					t = newT;
					tc = t;
					collided = true;
					collisionPoint = vv[i]; // Miejscem kolizji bdzie wierzchoek.
					reaction = basePoint - collisionPoint; // Kierunkiem reakcji bdzie kierunek pomidzy rodkiem kuli a wierzchokiem.
					
					//printf("%s: vertex\n", parent->Name);
				}
			}

		#pragma endregion

		#pragma region Sprawdzenie kolizji z krawdziami polygonu.

			// Wymaga rozwizania rwnania kwadratowego dla kadej z krawdzi polygonu.
			// Wytumaczenie wspczynnikw a, b, c znale mona w sugerowanej literaturze.

			for (int i = 0; i < vNum; ++i) {
				vec3 e = vv[(i + 1) % vNum] - vv[i];
				vec3 btv = vv[i] - base;
				float eL2 = e.Length2();
				float edv = e.Dot(velocity);
				float edbtv = e.Dot(btv);
				a = -eL2 * velocityL2 + edv * edv;
				b = eL2 * 2.0f * velocity.Dot(btv) - 2.0f * edv * edbtv;
				c = eL2 * (1.0f - btv.Length2()) + edbtv * edbtv;
			
				if (CCollisionDetection::GetSmallestPositiveQuadEqSolution(a, b, c, t, newT)) {
					
					// Obliczamy wspczynnik okrelajcy odlego od jednego wierzchoka krawdzi do drugiego,
					// odpowiadajcy odlegoci po ktrej jest miejsce wystpienia kolizji.
					float f = (edv * newT - edbtv) / eL2;

					// Jeli jestemy w obrbie krawdzi (f=0..1)...
					if (f >= 0.0f && f <= 1.0f) {
						//...to mamy kolizj!
						t = newT;
						tc = t;
						collided = true;
						collisionPoint = vv[i] + e * f; // Miejscem kolizji jest punkt oddalony o "f" od pierwszego z wierzchokw krawdzi, w stron drugiego z wierzchokw.
						reaction = basePoint - collisionPoint; // Kierunkiem reakcji bdzie kierunek pomidzy rodkiem kuli a miejscem kolizji.
						//printf("%s: edge\n", parent->Name);
					}
				}
			}

		#pragma endregion

	}

	#pragma region Ustawienie odpowiedzi o kolizji.
		
		if (collided) {

			// Odlego od punktu startowego, po ktrej nastpuje znaleziona kolizja (w pierwotnej przestrzeni!).
			float distToCollision = tc * (pos1 - pos0).Length();

			// Czy znaleziona kolizja jest blisza od poprzednio uznanej za najblisz?
			// (lub czy do tej pory jeszcze nie znaleziono adnej?)
			if (!result.hasCollided || result.distance > distToCollision) {
				
				// Powracamy do pierwotnej przestrzeni.
				reaction.Scale(e->r);
				reaction.Normalize();
				collisionPoint.Scale(e->r);

				result.hasCollided = true; // Doszo do kolizji!
				result.target = this; // Z czym doszo do kolizji?
				result.t = tc; // Wspczynnik 0..1 przemieszczenia po jakim nastpuje kolizja.
				result.distance = distToCollision; // Odlego ktr mona przeby do wystpienia kolizji.
				result.planeIntersectionPosition = collisionPoint; // Punkt przecicia z polygonem - miejsce kolizji.
				result.reaction = reaction; // Kierunek reakcji na kolizj.

			}
		}

	#pragma endregion

	delete[] vv;

}

bool CCollisionPolygon::CheckPointInPolygon(vec3 p, vec3 *vv) {
	// Test "Point In Polygon", czyli sprawdzenie czy zadany punkt ley wewntrz wielokta.
	// Metoda do brzydka, ale do blu prosta. Sprawdzenie, czy suma ktw pomidzy
	// zadanym punktem a kolejnymi parami wierzchokw jest rwna 2*PI. Jeli punkt bdzie
	// poza wieloktem, suma ktw bdzie inna. eby zrozumie, wystarczy zrobi sobie prosty rysunek.
	float angle = 0.0f;
	for (int i = 0; i < vNum; ++i) {
		vec3 a = vv[i] - p;
		vec3 b = vv[(i + 1) % vNum] - p;
		float albl = a.Length() * b.Length();
		angle += acos(a.Dot(b) / albl);
	}
	if (abs(angle - PI * 2.0f) > .01f) {
		return false;
	}
	return true;
}
