#pragma once

// Paszczyzna wraz z uytecznymi metodami.
class CCollisionPlane {
public:

	// Jednoznaczna definicja paszczyzny: Ax + By + Cz + D = 0
	vec3 N; // Wektor normalny (ABC).
	float Cp; // D (-N*P0, gdzie P0 jest punktem na paszczynie a * oznacza iloczyn skalarny)

	CCollisionPlane() {
		N.Set(0.0f, 0.0f, -1.0f);
		Cp = 0.0f;
	}

	// Konstruktor - budowa z zestawu punktw.
	CCollisionPlane(vec3 v[]) {
		FromPoints(v);
	}

	// Konstruktor - budowa z wektora normalnego i punktu lecego na paszczynie.
	CCollisionPlane(vec3 nN, vec3 pO) {
		FromNormalAndPoint(nN, pO);
	}

	// Budowa paszczyzny z trzech punktw na niej lecych.
	void FromPoints(vec3 v[]) {
		vec3::Cross(v[2] - v[1], v[0] - v[1], N);
		N.Normalize();
		Cp = -N.Dot(v[0]);
	}

	// Budowa paszczyzny z wektora normalnego i punktu na tej paszczynie.
	void FromNormalAndPoint(vec3 nN, vec3 pO) {
		N = nN;
		N.Normalize();
		Cp = -N.Dot(pO);
	}

	// Czy dany wektor jest skierowany w stron przedniej strony paszczyzny, lub jest do niej rwnolegy?
	bool IsFrontFacingTo(vec3 v) {
		return N.Dot(v) <= 0.0f;
	}

	// Najkrtsza odlego zadanego punktu do paszczyzny (ze znakiem).
	float SDistanceTo(vec3 p) {
		return p.Dot(N) + Cp;
	}
	
	// Najkrtsza odlego zadanego punktu do paszczyzny (bez znaku).
	float DistanceTo(vec3 p) {
		return abs(p.Dot(N) + Cp);
	}

	// Projekcja punktu na paszczyzn.
	vec3 Project(vec3 p) {
		return p - N * N.Dot(p);
	}
};
