#include "stdafx.h"

vec3 CCollisionDetection::GetPositionAfterWorldCollisions(vec3 pos0, vec3 pos1, CPlayer &player, vector<CSceneObject *> * objects, int step, CCollisionPolygon * exclude) {

	// Funkcja bdzie wywoywana reukrencyjnie. Jeli poziom zagniedenia przekroczy 10,
	// to zwracamy po prostu pos1 jako nasz now, "zmodyfikowan" pozycj.
	// Take w sytuacji, gdy dugo naszego przewidywanego ruchu jest rwna 0 (gracz stoi w miejscu),
	// to nie ma sensu wykonywa oblicze.
	if (step > 10 || (pos1 - pos0).Length() == 0.0f) {
		return pos1;
	}

	// Tu bd przechowywane dane o kolizji.
	SCollision collision;

	// Sprawdmy, czy dochodzi do kolizji elipsoidy gracza z ktrymkolwiek z obiektw
	// spord tych przekazanych jako "objects". W midzyczasie zostanie zapisana informacja
	// o najbliszej z kolizji (jeli jakakolwiek zostanie wykryta).
	for (int i = 0; i < objects->size(); ++i) {

		// W naszym przykadzie chcemy sprawdza kolizje jedynie z obiektami klasy CWall, bo z nimi
		// bdziemy wiedzieli co zrobi. Ten fragment na pewno naley zmodyfikowa zalenie
		// od wasnych potrzeb.

		// Rzutujemy nasz wskanik na "jaki" obiekt na wskanik na CWall.
		CWall * wall = reinterpret_cast<CWall *>(objects->at(i));

		// Jeli uylimy reinterpret_cast zamiast zwykego static_cast (lub
		// rwnowanego zapisu (CWall*)(objects->at(i)), to w momencie gdy rzutowanie
		// nie jest moliwe, otrzymamy warto NULL. Wtedy wiadomo, e nie jest to na pewno
		// CWall i pomijamy ten obiekt.
		// Pomijamy te obiekt jeli jest to ten sam, co obiekt do ktrego adres zosta
		// przekazany w parametrze - zostanie to uyte do rozwizania sytuacji gdy odbicie si
		// od jednego obiektu skutkuje odbiciem si od drugiego.
		if (wall == NULL || wall->collisionPolygon == exclude) {
			continue;
		}

		// Wywoujemy sprawdzanie kolizji elipsoidy gracza z polygonem danej "ciany", na odcinku pos0 => pos1.
		// Wyniki bd zapisane w "collision", pod warunkiem e wczeniej nie znajdowaa si tam
		// blisza kolizja.
		wall->collisionPolygon->CheckCollision(pos0, pos1, player.collisionEllipsoid, collision);
	}

	// Jeli udao si wykry jakkolwiek kolizj (wtedy collision zawiera informacje o tej wystpujcej najbliej)...
	if (collision.hasCollided) {
		
		// Ustawienie informacji o punkcie kolizji na potrzeby ewentualnego narysowania (klawisz "K").
		Scene->LastCollisionPoint = collision.planeIntersectionPosition;
		Scene->MarkCollision = true;

		// danie wyliczenia odpowiedzi (reakcji) na kolizj. Uaktualniona pozycja bdzie t, do ktrej
		// gracz powinien si przemieci po zaistnieniu tej kolizji.
		pos1 = CalculateReaction(pos0, pos1, collision);
		
		// Wywoujemy rekurencyjnie sprawdzanie i reakcj na kolizj, tym razem dla zaktualizowanej
		// cieki - zamiast pierwotnego pos1, mamy pozycj po uwzgldnieniu reakcji na dotychczas
		// znalezion kolizj. Dodatkowo w nastpnym rozwaaniu pomijamy kolizje z polygonem, z ktrym
		// teraz j wykrylimy. Wynik zwracamy poziom wyej.
		return GetPositionAfterWorldCollisions(pos0, pos1, player, objects, step + 1, collision.target);

	}

	// Jeli nie byo kolizji, idziemy miao tam gdzie mielimy i.
	return pos1;
}

vec3 CCollisionDetection::CalculateReaction(vec3 pos0, vec3 pos1, SCollision &collision) {

	// Offset, o ktry odsuwamy si od ciany w celu uniknicia tunelowania.
	// Jest to warto dobrana eksperymentalnie. To ona odpowiada za "skakanie" przy cianach,
	// ale podczas jej zmniejszania dochodzi czasem do przejcia przez cian.
	// Zachcam do poszukania lepszego rozwizania!
	float eps = .015f;

	vec3 vel = pos1 - pos0;
	vec3 destPoint = pos0 + vel;

	vec3 newVelocityVector;

	// Wyznaczenie paszczyzny, wzdu ktrej gracz bdzie si porusza po dotkniciu obiektu z ktrym
	// nastpia kolizja.
	CCollisionPlane slidingPlane(collision.reaction, collision.planeIntersectionPosition);

	// Wyznaczenie wektora przemieszczenia odpowiadajcego temu fragmentowi ruchu, ktry odbyby si
	// "za powierzchni ciany".
	vec3 newDestPoint = destPoint - slidingPlane.N * (slidingPlane.SDistanceTo(destPoint));
	newVelocityVector = newDestPoint - collision.planeIntersectionPosition;

	// Wyznaczenie nowej pozycji:
	pos1 = pos0 + vel * collision.t; // Docignicie najbliej do ciany.
	pos1 = pos1 + newVelocityVector; // Przesunicie wzdu paszczyzny "slidingu".
	pos1 = pos1 + collision.reaction * eps; // Odsunicie si od ciany (najbrzydsza cz caego rozwizania).

	// Zwracamy now pozycj.
	return pos1;
}

float CCollisionDetection::GetSmallestPositiveQuadEqSolution(float a, float b, float c, float xMin, float &newXMin) {
	// Rozwizanie rwnania kwadratowego i sprawdzenie, czy ktre z uzyskanych rozwiza jest mniejsze ni
	// to dotychczas uznawane za najmniejsze (xMin), przy zaoeniu e nie interesuj nas rozwizania mniejsze od zera.
	float x1, x2;
	if (!SolveQuadEq(a, b, c, x1, x2) || (x1 < 0.0f && x2 < 0.0f) || (x1 > xMin && x2 > xMin)) {
		return false;
	}
	float x;
	if (x1 > x2) {
		float tmp = x1;
		x1 = x2;
		x2 = tmp;
	}
	if (x1 < 0.0f) {
		x = x2;
	}
	else {
		x = x1;
	}
	if (x < xMin) {
		newXMin = x;
		return true;
	}
	return false;
}

bool CCollisionDetection::SolveQuadEq(float a, float b, float c, float &x1, float &x2) {
	// Rozwizanie rwnania kwadratowego metod ze szkoy redniej (delta).
	float delta = b * b - 4.0f * a * c;
	if (delta < 0.0f) {
		return false;
	}
	float sqrDelta = sqrt(delta);
	x1 = (-b - sqrDelta) / (2.0f * a);
	x2 = (-b + sqrDelta) / (2.0f * a);
	return true;
}
